tokage.tag = {};

// 共通処理のためにラップする
tokage.tag.process = function(ram, sav, tagName, o, callback)
{
	console.log("[" + tagName + "] in " + sav.pointer);
	console.log(o);
	if (tokage.tag[tagName] != null)
	{
		return tokage.tag[tagName](ram, sav, o, callback);
	}
	return -1;
};

// storage(M) time(O)
tokage.tag["back"] = function(ram, sav, o, callback)
{
	if (o.storage == null) { console.log("ERROR: storage is null"); return -1; }
	var time = parseInt(o.time || "0");
	
	var p = { storage : o.storage, layer : "base", left : "0", top : "0" };
	tokage.tag["image"](ram, sav, p, callback);
	
	return tokage.tag["trans"](ram, sav, { time : time }, callback);
};

// [chapter]
// title(M)
tokage.tag["chapter"] = function(ram, sav, o, callback)
{
	if (o.title == null) { console.log("ERROR: title is null"); return -1; }
	sav.summary.chapter = o.title;
	return 0;
};


// name(M) storage(M) face(M)
tokage.tag["chara_face"] = function(ram, sav, o, callback)
{
	if (o.name == null) { console.log("ERROR: name is null"); return -1; }
	if (o.storage == null) { console.log("ERROR: storage is null"); return -1; }
	if (o.face == null) { console.log("ERROR: face is null"); return -1; }
	
	if (sav.charas[o.name] == null) { console.log("ERROR: character is not defined"); return -1; }
	
	sav.charas[o.name].faces[o.face] = { storage : o.storage };
	return 0;
};

// name(M) time(O)
tokage.tag["chara_hide"] = function(ram, sav, o, callback)
{
	if (o.name == null) { console.log("ERROR: name is null"); return -1; }
	var time = parseInt(o.time || "0");
	var layer = tokage.data.findLayer(sav, o.name);
	if (layer == null) { console.log("ERROR: character have not shown"); return -1; }
	
	tokage.tag["/image"](ram, sav, { layer : layer }, callback);
	return tokage.tag["trans"](ram, sav, { time : time }, callback);
};

// name(M) storage(M) jname(M)
tokage.tag["chara_new"] = function(ram, sav, o, callback)
{
	if (o.name == null) { console.log("ERROR: name is null"); return -1; }
	if (o.storage == null) { console.log("ERROR: storage is null"); return -1; }
	if (o.jname == null) { console.log("ERROR: jname is null"); return -1; }
	
	sav.charas[o.name] =
	{
		jname : o.jname,
		faces :
		{
			"default" : { storage : o.storage }
		}
	};
	
	return 0;
};

// name(O) face(O) time(O)
tokage.tag["chara_act"] = function(ram, sav, o, callback)
{
	var time = parseInt(o.time || "0");
	
	if (o.name == null || o.name === "") // todo: 空文字のほうの判定は不要では？
	{
		sav.actCharaName = null;
		$(tokage.NAME_AREA).html("");
	}
	else
	{
		var chara = sav.charas[o.name];
		if (chara == null) { console.log("ERROR: character is not defined"); return -1; }
		
		var layer = tokage.data.findLayer(sav, o.name);
		if (layer != null)
		{
			if (o.face != null) // 指定されている場合のみ画像変更
			{
				var face = chara.faces[o.face];
				if (face != null)
				{
					var storage = face.storage;
					if (storage != null)
					{
						var left = sav.layers[layer].left;
						var top  = sav.layers[layer].top;
						var flip = "" + sav.layers[layer].flip; // ここは文字列で渡す！
						var p = { storage : storage, layer : layer, left : left, top : top, flip : flip };
						tokage.tag["image"](ram, sav, p, callback);
					}
				}
			}
		}
		sav.actCharaName = o.name;
		$(tokage.NAME_AREA).html(chara.jname);
	}
	
	return tokage.tag["trans"](ram, sav, { time : time }, callback);
};

// name(M) face(O) layer(O) time(O) left(O) top(O) flip(O)
tokage.tag["chara_show"] = function(ram, sav, o, callback)
{
	if (o.name == null) { console.log("ERROR: name is null"); return -1; }
	var face = o.face || "default";
	var layer = o.layer || tokage.data.findEmptyLayer(sav);
	if (layer == null) { console.log("ERROR: layer is full"); return -1; }
	var time = parseInt(o.time || "0");
	var left = parseInt(o.left || "0");
	var top = parseInt(o.top || "0");
	var flip = o.flip || "false"; // ここではまだ文字列型でよい
	var storage = sav.charas[o.name].faces[face].storage;
	
	var p = { storage : storage, layer : layer, left : left, top : top, flip : flip };
	tokage.tag["image"](ram, sav, p, callback);
	
	sav.layers[layer].name = o.name;
	sav.layers[layer].face = face;
	
	//console.log(sav);
	//console.log(ram);
	
	return tokage.tag["trans"](ram, sav, { time : time }, callback);
};

tokage.tag["cm"] = function(ram, sav, o, callback)
{
	$(tokage.TEXT_AREA).empty();
	return 0;
};

// exp(M)
tokage.tag["emb"] = function(ram, sav, o, callback)
{
	if (o.exp == null) { console.log("ERROR: exp is null"); return -1; }
	
	with (sav.f)
	{
		var val = eval(o.exp);
		$(tokage.TEXT_AREA).append("" + val);
	}
	return 0;
};


// exp(M)
tokage.tag["eval"] = function(ram, sav, o, callback)
{
	if (o.exp == null) { console.log("ERROR: exp is null"); return -1; }
	
	with (sav.f)
	{
		eval(o.exp);
	}
	return 0;
};

// size(O) color(O) bold(O) face(O)
tokage.tag["font"] = function(ram, sav, o, callback)
{
	ram.destinationLevel++;
	
	var style ="";
	if (o.size != null) style += "font-size: " + o.size + "; ";
	if (o.color != null) style += "color: " + o.color + "; ";
	if (o.bold === "true") style += "font-weight: bold; ";
	else if (o.bold === "false") style += "font-weight: normal; ";
	if (o.face != null) style += "font-family: " + o.face + "; ";
	
	var id = "destination" + ram.destinationLevel;
	var text = "<span id='" + id + "' style=\"" + style + "\"></span>";
	
	if (ram.destinationLevel <= 1)
	{
		$(tokage.TEXT_AREA).append(text);
	}
	else
	{
		$("#destination" + (ram.destinationLevel - 1)).append(text);
	}
	
	return 0;
};

tokage.tag["/font"] = function(ram, sav, o, callback)
{
	$("#destination" + ram.destinationLevel).removeAttr("id");
	
	ram.destinationLevel--;
	
	return 0;
};

// exp(M) storage(O) target(O)
tokage.tag["ifjump"] = function(ram, sav, o, callback)
{
	if (o.exp == null) { console.log("ERROR: exp is null"); return -1; }
	
	with (sav.f)
	{
		if (eval(o.exp))
		{
			tokage.tag["jump"](ram, sav,
				{ target : o.target, storage : o.storage });
		}
	}
	return 0;
};

// storage(M) layer(O) left(O) x(O) top(O) y(O) flip(O)
tokage.tag["image"] = function(ram, sav, o, callback)
{
	if (o.storage == null) { console.log("ERROR: storage is null"); return -1; }

	var l = o.layer || "base";
	var x = parseInt(o.x || o.left || "0");
	var y = parseInt(o.y || o.top  || "0");
	var flip = ((o.flip || "false") === "true"); // booleanにする！
	
	var storage = o.storage;
	if (l === "base") { storage = "./data/bgimage/" + storage; }
	else { storage = "./data/fgimage/" + storage; }
	
	var img = new Image();
	ram.loadingCount++;
	img.src = storage;
	img.onload = function() { ram.loadingCount--; };
	
	// backにロードする
	
	// (ram)
	if (ram.layers[l] == null)
	{
		ram.layers[l] = { fore : { img : null }, back : { img : null } };
	}
	ram.layers[l].back.img = img;
	
	// (sav)
	if (sav.layers[l] == null)
	{
		sav.layers[l] = { fore : { storage : null }, back : { storage : null } };
	}
	sav.layers[l].left = x;
	sav.layers[l].top = y;
	sav.layers[l].flip = flip;
	sav.layers[l].back.storage = storage;
	sav.layers[l].transed = false; // フェード要求
	
	// if (l !== "base") console.log("transed(" + l + ") <= " + sav.layers[l].transed + " in [image]");
	
	// ram.loadingCountが1以上の状態でtransに入る
	// transはこれが0になるまで待機する
	
	return 0;
};

// layer(O)
tokage.tag["/image"] = function(ram, sav, o, callback)
{
	var l = o.layer || "base";
	
	sav.layers[l].transed = false; // フェード要求
	
	return 0;
};

// storage(O) target(O)
tokage.tag["jump"] = function(ram, sav, o, callback)
{
	if (o.storage != null)
	{
		tokage.loadScript(sav, o.storage);
	}
	
	if (o.target != null)
	{
		sav.pointer = 0;
		ram.searchingLabel = o.target;
	}
	
	return 0;
};

tokage.tag["l"] = function(ram, sav, o, callback)
{
	sav.stopTagName = "l";
	
	if (!ram.skipMode)
	{
		$(tokage.NEXT_DIV).css("display", "block");
		
		// アイコンを表示する
		$(tokage.TEXT_AREA).append( $("<img class='click_icon' src='./data/system/click.gif'>") );
	}
	
	
	return (ram.skipMode) ? 200 : -1;
};

// [lr]
// →正規表現で対応

// [lcm]
// →正規表現で対応

// name(M)
tokage.tag["label"] = function(ram, sav, o, callback)
{
	if (o.name == null) { console.log("ERROR: name is null"); return -1; }
	
	return 0;
};

// code(M)
tokage.tag["lang"] = function(ram, sav, o, callback)
{
	if (o.code == null) { console.log("ERROR: code is null"); return -1; }
	sav.lang = o.code;
	return 0;
};

// target storage
tokage.tag["link"] = function(ram, sav, o, callback)
{
	ram.destinationLevel++;
	
	var storage = "null"; if (o.storage != null) storage = "'" + o.storage + "'";
	var target  = "null"; if (o.target  != null) target  = "'" + o.target  + "'";
	var id = "destination" + ram.destinationLevel;
	var text = "<span id='" + id + "' class='link' onClick=\"onLinkClick(ram, sav, " +
		storage + ", " + target + ")\"></span>";
	
	if (ram.destinationLevel <= 1)
	{
		$(tokage.TEXT_AREA).append(text);
	}
	else
	{
		$("#destination" + (ram.destinationLevel - 1)).append(text);
	}
	
	return 0;
};

tokage.tag["/link"] = function(ram, sav, o, callback)
{
	$("#destination" + ram.destinationLevel).removeAttr("id");
	
	ram.destinationLevel--;
	
	return 0;
};

tokage.tag["nowait"] = function(ram, sav, o, callback)
{
	ram.noWait = true;
	return 0;
};

tokage.tag["/nowait"] = function(ram, sav, o, callback)
{
	ram.noWait = false;
	return 0;
};

// text(M)
tokage.tag["put"] = function(ram, sav, o, callback)
{
	if (o.text == null) { console.log("ERROR: text is null"); return -1; }
	
	if (ram.destinationLevel > 0)
	{
		$("#destination" + ram.destinationLevel).append(o.text);
	}
	else
	{
		$(tokage.TEXT_AREA).append(o.text);
	}
	
	if (ram.noWait) return 0;
	return (ram.skipMode) ? 2 : 25;
};

tokage.tag["r"] = function(ram, sav, o, callback)
{
	$(tokage.TEXT_AREA).append("<br />");
	
	if (ram.noWait) return 0;
	return (ram.skipMode) ? 25 : 200;
};

tokage.tag["s"] = function(ram, sav, o, callback)
{
	sav.stopTagName = "s";
	
	return -1;
};

// time(O)
tokage.tag["trans"] = function(ram, sav, o, callback)
{
	if (callback == null) { console.log("ERROR: callback is null"); return -1; }
	
	var time = parseInt(o.time || "0");
	var transLoop = function(t, tmax, callback)
	{
		// まだ画像読み込みが完了していない場合、tを更新せずに再度setTimeout()する
		if (ram.loadingCount > 0)
		{
			console.log("INFO: wait 20ms until image load");
			setTimeout( function() { transLoop(t, tmax, callback); }, 20 );
			return;
		}
		
		t -= 30; if (t < 0) t = 0;
		
		// tは1→0, transTimeは0→1と変化する
		// backにロードされた画像が徐々に見えてくる
		ram.transTime = 1.0;
		if (tmax != 0) { ram.transTime = 1.0 - t / tmax; }
		
		// canvasへの描画を行う
		tokage.canvas.draw(ram, sav);
		
		if (t == 0)
		{
			// backの情報をforeに移動する
			tokage.canvas.backToFore(ram, sav);
			
			// index.html.jsのloop()を再開する
			callback();
			
			// setTimeout()せずにreturn (trans終了)
			return;
		}
		
		// 再度setTimeout()する (繰り返す)
		setTimeout( function() { transLoop(t, tmax, callback); }, 30 );
	};
	
	// タグ終了文字']'が出力され次の文字が消えてしまう現象が発生
	// timeが30未満の時、この関数が終わる前にcallbackを呼び出してしまうのが原因
	// 直にtransLoop()と呼ぶのではなく、面倒でもsetTimeout()で遅延呼び出しすること！
	// transLoop(time, time, callback);
	setTimeout( function() { transLoop(time, time, callback); }, 0 );
	
	return -1;
};

// time
tokage.tag["wait"] = function(ram, sav, o, callback)
{
	var time = parseInt(o.time || "0");
	if (ram.skipMode) return 0;
	return time;
};

